<?php

use Sabberworm\CSS\Property\Selector;
use Sabberworm\CSS\Rule\Rule;
use Sabberworm\CSS\RuleSet\DeclarationBlock;
use Sabberworm\CSS\Value\Color;
use Sabberworm\CSS\Value\RuleValueList;
use Symfony\Component\Finder\Finder;

require __DIR__ . '/../vendor/autoload.php';

$finder = new Finder();
$finder
    ->in(__DIR__ . '/../styles/')
    ->name('*.css')
    ->sortByName()
    ->files()
;

$backgroundColors = array();

/** @var \Symfony\Component\Finder\SplFileInfo $file */
foreach ($finder->getIterator() as $file) {
    $themeName = $file->getBasename('.css');
    $backgroundColors[$themeName] = array(
        'r' => 255,
        'g' => 255,
        'b' => 255,
    );
    $cssParser = new Sabberworm\CSS\Parser($file->getContents());
    $cssDocument = $cssParser->parse();

    /** @var DeclarationBlock $ruleSet */
    foreach ($cssDocument->getAllRuleSets() as $ruleSet) {
        /** @var Selector $selector */
        foreach ($ruleSet->getSelectors() as $selector) {
            if ($selector->getSelector() === '.hljs') {
                $bgColor = $ruleSet->getRules('background');

                if (empty($bgColor)) {
                    $bgColor = $ruleSet->getRules('background-color');
                }

                /** @var RuleValueList|Rule $value */
                foreach ($bgColor as $value) {
                    $isColor = $value->getValue() instanceof Color;
                    $isValueList = $value->getValue() instanceof RuleValueList;

                    if (!$isColor && !$isValueList) {
                        continue;
                    }

                    if ($isColor) {
                        $colorValue = $value->getValue()->getColor();
                    } elseif ($isValueList) {
                        /** @var RuleValueList $valueList */
                        foreach ($value->getValue()->getListComponents() as $valueList) {
                            if ($valueList instanceof Color) {
                                $colorValue = $valueList->getColor();
                                break;
                            }
                        }
                    }

                    $backgroundColors[$themeName] = array(
                        'r' => $colorValue['r']->getSize(),
                        'g' => $colorValue['g']->getSize(),
                        'b' => $colorValue['b']->getSize(),
                    );

                    break 3;
                }
            }
        }
    }
}

$document = <<<'PHP'
<?php

// DO NOT MODIFY. This file is automatically generated.

/**
 * Get the background color for a specific CSS theme.
 *
 * @param string $theme The theme name
 *
 * @throws \DomainException when no stylesheet with this name exists
 *
 * @return float[]
 */
function _getThemeBackgroundColor($theme)
{
    $colors = {colorMapping};

    if (!isset($colors[$theme])) {
        throw new DomainException("There is no stylesheet by the name of '$theme'");
    }

    return $colors[$theme];
}

PHP;

$document = strtr($document, array(
    '{colorMapping}' => var_export($backgroundColors, true),
));

file_put_contents(__DIR__ . '/../HighlightUtilities/_themeColors.php', $document);
