<?php

use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', function () { return view('index');});
Route::post('/loginpost','LoginController@loginpost')->name('loginpost');
Route::get('/logout','LoginController@logout');

Route::middleware(['checklogin'])->group(function(){

Route::get('/dashboard', function () {return view('index2');})->name('dashboard');
Route::get('/category/{id?}', 'UserController@category')->name('category');
Route::get('/editproject/{id?}', 'UserController@editproject')->name('projectlist'); 
Route::get('/expense','UserController@expensive');

Route::get('/addwork','UserController@addwork');

Route::get('addunit/{id?}','UserController@addunit');
Route::post('saveunit','UserController@saveunit');
Route::get('unitlist', function () { return view('unitlist');});



Route::get('/categorylist', function () { return view('categorylist');});
Route::get('/subcategorylist', function () { return view('subcategorylist');});
Route::get('/superviserlist', function () { return view('superviserlist');});


Route::match(['get','post'],'/expenseslist','UserController@expenseslist');
Route::match(['get','post'],'/worklist','UserController@worklist');
Route::match(['get','post'],'/projectlist','UserController@projectlist');

Route::get('assignproject','UserController@assignproject');

Route::post('saveassignproject','UserController@saveassignproject')->name('saveassignproject');



Route::get('/addamount', function () {  return view('addamount');});
Route::get('/amountlist', function () {  return view('amountlist');});


Route::get('/createproject','UserController@create_project')->name('createproject');
Route::post('/createproject','UserController@save_project')->name('save_project');
Route::post('/update_project','UserController@update_project')->name('update_project');
Route::get('/subcategory/{id?}', 'UserController@sub_categoty')->name('subcategory');
Route::post('/category', 'UserController@create_categoty')->name('postcategory');
Route::post('/subcategory', 'UserController@create_subcategoty')->name('postsubcategory');
Route::get('/getSubcategory/{id}', 'UserController@getSubcategory');
Route::get('/getpersonname/{id}', 'UserController@getpersonname');
Route::post('/saveexpenses', 'UserController@saveexpenses')->name('saveexpenses');
Route::post('/savework', 'UserController@savework')->name('savework');

Route::post('/saveamount', 'UserController@saveamount')->name('saveamount');
Route::get('/approved/{id?}','UserController@approvedamount');
Route::get('/disapproved/{id?}/{table?}','UserController@disapprovedamount');
Route::post('/approvework/','UserController@approvework');

Route::get('/deletewala/{id?}/{table?}','UserController@deletewala')->name('deletewala');
});



